export const storeCustomization = {
  navbar: {
    categories_menu_status: true,
    about_menu_status: true,
    contact_menu_status: true,
    offers_menu_status: true,
    term_and_condition_status: true,
    privacy_policy_status: true,
    faq_status: true,
    help_text: {
      en: "We are available 24/7, Need help?",
      de: "Wir sind erreichbar 24/7, Brauchen Sie Hilfe?",
    },
    categories: {
      en: "Categories",
      de: "Kategorien",
    },
    about_us: {
      en: "About Us",
      de: "Uber Uns",
    },
    contact_us: {
      en: "Contact Us",
      de: "Kontaktiere Uns",
    },
    offers: {
      en: "Offers",
      de: "Bietet an",
    },
    faq: {
      en: "FAQ",
      de: "FAQ",
    },
    privacy_policy: {
      en: "Privacy Policy",
      de: "Datenschutzrichtlinie",
    },
    term_and_condition: {
      en: "Terms & Conditions",
      de: "Terms & Bedingungen",
    },
    pages: {
      en: "Pages",
      de: "Seiten",
    },
    my_account: {
      en: "My Account",
      de: "Mein Konto",
    },
    login: {
      en: "Login",
      de: "Anmeldung",
    },
    logout: {
      en: "Logout",
      de: "Ausloggen",
    },
    checkout: {
      en: "Checkout",
      de: "Kasse",
    },
    phone: "+965 505 631288",
    logo: "https://res.cloudinary.com/ahossain/image/upload/v1697687802/settings/logo-light_hls14v.svg",
  },
  home: {
    coupon_status: true,
    featured_status: true,
    daily_needs_status: true,
    slider_width_status: false,
    promotion_banner_status: true,
    delivery_status: true,
    popular_products_status: true,
    discount_product_status: true,
    feature_promo_status: true,
    discount_coupon_code: ["WINTER21", "OCTOBER21"],
    place_holder_img: "",
    discount_title: {
      en: "Latest Super Discount Active Coupon Code",
      de: "Neuester aktiver Super-Rabatt-Gutscheincode",
    },
    promotion_title: {
      en: "100% Natural Quality Organic Product",
      de: "100 % natürliches Bio-Qualitätsprodukt",
    },
    promotion_description: {
      en: "See Our latest discounted products from here and get a special discount product",
      de: "Sehen Sie sich hier unsere neuesten reduzierten Produkte an und sichern Sie sich ein spezielles Rabattprodukt",
    },
    promotion_button_name: {
      en: "Shop Now",
      de: "Jetzt einkaufen",
    },
    promotion_button_link: "/search?category=breakfast",
    feature_title: {
      en: "Featured Categories",
      de: "Beliebte Kategorien",
    },
    feature_description: {
      en: "Choose your necessary products from this feature categories.",
      de: "Wählen Sie aus diesen Funktionskategorien die gewünschten Produkte aus.",
    },
    feature_product_limit: 18,
    popular_title: {
      en: "Popular Products for Daily Shopping",
      de: "Beliebte Produkte für den täglichen Einkauf",
    },
    popular_description: {
      en: "See all our popular products in this week. You can choose your daily needs products from this list and get some special offer with free shipping.",
      de: "Sehen Sie sich diese Woche alle unsere beliebten Produkte an. Aus dieser Liste können Sie Produkte für den täglichen Bedarf auswählen und ein Sonderangebot mit kostenlosem Versand erhalten.",
    },
    popular_product_limit: 18,
    quick_delivery_subtitle: {
      en: "Organic Products and Food",
      de: "Bio-Produkte und Lebensmittel",
    },
    quick_delivery_title: {
      en: "Quick Delivery to Your Home",
      de: "Schnelle Lieferung zu Ihnen nach Hause",
    },
    quick_delivery_description: {
      en: "There are many products you will find in our shop, Choose your daily necessary product from our KachaBazar shop and get some special offers. See Our latest discounted products from here and get a special discount.",
      de: "Es gibt viele Produkte, die Sie in unserem Shop finden. Wählen Sie Ihr täglich benötigtes Produkt aus unserem KachaBazar-Shop und erhalten Sie einige Sonderangebote. Sehen Sie sich hier unsere neuesten reduzierten Produkte an und sichern Sie sich einen Sonderrabatt.",
    },
    quick_delivery_button: {
      en: "Download App",
      de: "Lade App herunter",
    },
    quick_delivery_link: "#",
    quick_delivery_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697688032/settings/delivery-boy_rluuoq.webp",
    latest_discount_title: {
      en: "Latest Discounted Products",
      de: "Neueste reduzierte Produkte",
    },
    latest_discount_description: {
      en: "See Our latest discounted products below. Choose your daily needs from here and get a special discount with free shipping.",
      de: "Sehen Sie sich unten unsere neuesten reduzierten Produkte an. Wählen Sie hier Ihren täglichen Bedarf und erhalten Sie einen Sonderrabatt mit kostenlosem Versand.",
    },
    latest_discount_product_limit: 18,
    daily_need_title: {
      en: "Get Your Daily Needs From Our KachaBazar Store",
      de: "Holen Sie sich Ihren täglichen Bedarf in Ihrem CloudCleaver-Shop",
    },
    daily_need_description: {
      en: "There are many products you will find in our shop, Choose your daily necessary product from our KachaBazar shop and get some special offers.",
      de: "Es gibt viele Produkte, die Sie in unserem Shop finden. Wählen Sie Ihr täglich benötigtes Produkt aus unserem KachaBazar-Shop und erhalten Sie einige Sonderangebote.",
    },
    daily_need_app_link: "https://www.apple.com/app-store/",
    daily_need_google_link:
      "https://play.google.com/store/games?utm_source=apac_med&utm_medium=hasem&utm_content=Jun0122&utm_campaign=Evergreen&pcampaignid=MKT-EDR-apac-lk-1003227-med-hasem-py-Evergreen-Jun0122-Text_Search_BKWS-BKWS%7CONSEM_kwid_43700071429441653_creativeid_600975795576_device_c&gclid=CjwKCAjwwo-WBhAMEiwAV4dybdy60tnQqCSnQ-cXShNnEcxmaBx2I6iwwc_WEqoA5sN9YSLJEXh9fBoC3u4QAvD_BwE&gclsrc=aw.ds",
    daily_need_img_left:
      "https://res.cloudinary.com/ahossain/image/upload/v1697688091/settings/app-download-img-left_s5n2zf.webp",
    daily_need_img_right:
      "https://res.cloudinary.com/ahossain/image/upload/v1697688091/settings/app-download-img_c7xqg4.webp",
    button1_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697688165/settings/app-store_cyyc0f.svg",
    button2_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697688167/settings/play-store_cavwua.svg",
  },
  about_us: {
    header_status: true,
    content_left_status: true,
    content_right_status: true,
    content_middle_status: true,
    founder_status: true,
    header_bg:
      "https://res.cloudinary.com/ahossain/image/upload/v1697439245/settings/yw3cd2xupqwqpqcbxv9l.jpg",
    content_right_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697439245/settings/v7g6gowiju0wanpwx70f.jpg",
    content_middle_Img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697439195/settings/sl8vzvzm54jgzq6sphn2.jpg",
    founder_one_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697439688/settings/team-1_acjmv7.webp",
    founder_two_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697439689/settings/team-2_dw7zs1.webp",
    founder_three_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697439689/settings/team-3_ld3323.webp",
    founder_four_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697439689/settings/team-4_i7jvx7.webp",
    founder_five_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697439689/settings/team-5_ylyklw.webp",
    founder_six_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697439689/settings/team-6_gmlts4.webp",
    title: {
      en: "About Us",
      de: "Über uns",
    },
    top_title: {
      en: "Welcome to our KachaBazar shop",
      de: "Willkommen in unserem KachaBazar-Shop",
    },
    top_description: {
      en: "Holisticly seize parallel metrics and functional ROI.Seamlessly revolutionize error-free internal or organic sources before effective scenarios. Progressively incentivize state of the art applications for efficient intellectual capital. Credibly leverage existing distinctive mindshare through cutting-edge schemas. Proactively procrastinate team building paradigms coordinate client-centric total transparent internal.\n\nDynamically embrace diverse customer service and installed base paradigms. Credibly seize enterprise-wide experiences for end-to-end data. Professionally brand flexible alignments and cost effective architectures. Enthusiastically incentivize seamless communities with seamlessly facilitate revolutionary metrics with strategic theme areas.",
      de: "Erfassen Sie parallele Metriken und funktionalen ROI ganzheitlich. Revolutionieren Sie nahtlos fehlerfreie interne oder organische Quellen vor effektiven Szenarien. Fördern Sie nach und nach hochmoderne Anwendungen für effizientes intellektuelles Kapital. Nutzen Sie glaubwürdig vorhandenes unverwechselbares Mindshare durch hochmoderne Schemata. Teambuilding-Paradigmen proaktiv aufschieben koordinieren kundenzentriert total transparent intern. Umfassen Sie dynamisch unterschiedliche Kundendienst- und Installed-Base-Paradigmen. Nutzen Sie glaubwürdig unternehmensweite Erfahrungen für End-to-End-Daten. Professionelles Branding flexibler Ausrichtungen und kostengünstiger Architekturen. Schaffen Sie enthusiastische Anreize für nahtlose Gemeinschaften, indem Sie revolutionäre Metriken mit strategischen Themenbereichen nahtlos erleichtern.",
    },
    card_one_title: {
      en: "10K",
      de: "10K",
    },
    card_one_sub: {
      en: "Listed Products",
      de: "Gelistete Produkte",
    },
    card_one_description: {
      en: "Dynamically morph team driven partnerships after vertical",
      de: "Verwandeln Sie teamorientierte Partnerschaften dynamisch nach der Vertikalen",
    },
    card_two_title: {
      en: "8K",
      de: "8 TAUSEND",
    },
    card_two_sub: {
      en: "Lovely Customer",
      de: "Lieber Kunde",
    },
    card_two_description: {
      en: "Competently productize virtual models without performance.",
      de: "Virtuelle Modelle ohne Performance kompetent produzieren.",
    },
    middle_description_one: {
      en: "Holisticly seize parallel metrics and functional ROI. Seamlessly revolutionize error-free internal or organic sources before effective scenarios. Progressively incentivize state of the art applications for efficient intellectual capital. Credibly leverage existing distinctive mindshare through cutting-edge schemas. Proactively procrastinate team building paradigms coordinate client-centric total transparent internal. Energistically reconceptualize global leadership for high-quality networks. Credibly restore an expanded array of systems rather than accurate results. Collaboratively synergize backend bandwidth without 24/7 functionalities. Credibly utilize proactive ideas whereas cross-media core competencies. Uniquely maximize professional best practices through resource maximizing services. Conveniently architect cross-unit web services for e-business imperatives.",
      de: "Erfassen Sie parallele Metriken und funktionalen ROI ganzheitlich. Revolutionieren Sie nahtlos fehlerfreie interne oder organische Quellen vor effektiven Szenarien. Fördern Sie nach und nach hochmoderne Anwendungen für effizientes intellektuelles Kapital. Nutzen Sie glaubwürdig vorhandenes unverwechselbares Mindshare durch hochmoderne Schemata. Teambuilding-Paradigmen proaktiv aufschieben koordinieren kundenzentriert total transparent intern. Globale Führung für qualitativ hochwertige Netzwerke energisch neu konzipieren. Stellen Sie statt genauer Ergebnisse eine größere Anzahl von Systemen glaubwürdig wieder her. Synergisieren Sie gemeinsam Backend-Bandbreite ohne 24/7-Funktionalitäten. Proaktive Ideen glaubhaft nutzen und crossmediale Kernkompetenzen nutzen. Maximieren Sie auf einzigartige Weise professionelle Best Practices durch ressourcenoptimierende Services. Entwickeln Sie bequem bereichsübergreifende Webservices für E-Business-Anforderungen.",
    },
    middle_description_two: {
      en: "Appropriately visualize market-driven data before one-to-one scenarios. Collaboratively productize multifunctional ROI through intuitive supply chains. Enthusiastically seize revolutionary value and process-centric services. Competently harness intuitive information after interoperable markets. Interactively revolutionize future-proof value before granular sources. Dynamically embrace diverse customer service and installed base paradigms. Credibly seize enterprise-wide experiences for end-to-end data. Professionally brand flexible alignments and cost effective architectures. Enthusiastically incentivize seamless communities with seamlessly facilitate revolutionary metrics with strategic theme areas.",
      de: "Visualisieren Sie marktgesteuerte Daten angemessen vor Eins-zu-eins-Szenarien. Erzielen Sie gemeinsam multifunktionale Renditen durch intuitive Lieferketten. Nutzen Sie mit Begeisterung revolutionäre Mehrwert- und prozessorientierte Services. Nutzen Sie intuitive Informationen kompetent nach interoperablen Märkten. Revolutionieren Sie interaktiv zukunftssichere Werte vor granularen Quellen. Umfassen Sie dynamisch unterschiedliche Kundendienst- und Installed-Base-Paradigmen. Nutzen Sie glaubwürdig unternehmensweite Erfahrungen für End-to-End-Daten. Professionelles Branding flexibler Ausrichtungen und kostengünstiger Architekturen. Schaffen Sie enthusiastische Anreize für nahtlose Gemeinschaften, indem Sie revolutionäre Metriken mit strategischen Themenbereichen nahtlos erleichtern.",
    },
    founder_title: {
      en: "Our Team",
      de: "Unser Gründer",
    },
    founder_description: {
      en: "We’re impartial and independent, and every day we create distinctive, world-class reintermediate backend supply programmes.",
      de: "Wir sind unparteiisch und unabhängig und erstellen jeden Tag unverwechselbare, erstklassige Reintermediate-Backend-Lieferprogramme.",
    },
    founder_one_name: {
      en: "Niamh Shea",
      de: "Niamh Shea ",
    },
    founder_one_sub: {
      en: "Co-founder & Executive",
      de: "Co-founder & Executive",
    },
    founder_two_name: {
      en: "Orla Dwyer",
      de: "Orla Dwyer ",
    },
    founder_two_sub: {
      en: "Orla Dwyer",
      de: "Orla Dwyer ",
    },
    founder_three_name: {
      en: "Danien James",
      de: "Danien James ",
    },
    founder_three_sub: {
      en: "Co-founder, Chairman",
      de: "Co-founder, Chairman",
    },
    founder_four_name: {
      en: "Dara Frazier",
      de: "Dara Frazier ",
    },
    founder_four_sub: {
      en: "Chief Strategy Officer",
      de: "Chief Strategy Officer",
    },
    founder_five_name: {
      en: "Glenda Arvidson",
      de: "Glenda Arvidson",
    },
    founder_five_sub: {
      en: "HR Officer",
      de: " HR Officer",
    },
    founder_six_name: {
      en: "Melvin Davis ",
      de: "Melvin Davis ",
    },
    founder_six_sub: {
      en: "Lead Developer",
      de: "Lead Developer",
    },
  },
  contact_us: {
    header_status: true,
    email_box_status: true,
    call_box_status: true,
    address_box_status: true,
    left_col_status: true,
    form_status: true,
    header_bg:
      "https://res.cloudinary.com/ahossain/image/upload/v1697439245/settings/yw3cd2xupqwqpqcbxv9l.jpg",
    left_col_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697472924/settings/contact-us_zvwn2n.png",
    title: {
      en: "Contact Us",
      de: "Kontaktiere uns",
    },
    email_box_title: {
      en: "Email Us",
      de: "Schreiben Sie uns eine E-Mail",
    },
    email_box_email: {
      en: "info@kachabazar.com ",
      de: "info@kachabazar.com",
    },
    email_box_text: {
      en: "Interactively grow empowered for process-centric total linkage. ",
      de: " Interactively grow empowered for process-centric total linkage.",
    },
    call_box_title: {
      en: "Call Us ",
      de: "Rufen Sie uns an",
    },
    call_box_phone: {
      en: "029-00124667",
      de: "029-00124667",
    },
    call_box_text: {
      en: "Distinctively disseminate focused solutions clicks-and-mortar ministate. ",
      de: "Distinctively disseminate focused solutions clicks-and-mortar ministate.",
    },
    address_box_title: {
      en: "Location ",
      de: "Ort",
    },
    address_box_address_one: {
      en: "Boho One, Bridge Street West, Middlesbrough, North Yorkshire, TS2 1AE.",
      de: "Cecilia Chapman",
    },
    address_box_address_two: {
      en: "561-4535 Nulla LA ",
      de: "561-4535 Nulla LA",
    },
    address_box_address_three: {
      en: "United States 96522. ",
      de: "United States 96522",
    },
    form_title: {
      en: "For any suppoort just send your query ",
      de: "Für Unterstützung senden Sie einfach Ihre Anfrage",
    },
    form_description: {
      en: "Collaboratively promote client-focused convergence vis-a-vis customer-directed alignments via plagiarized strategic users and standardized infrastructures. ",
      de: "Fördern Sie gemeinsam die kundenorientierte Konvergenz gegenüber kundenorientierten Ausrichtungen durch Plagiate strategischer Benutzer und standardisierter Infrastrukturen.",
    },
  },
  offers: {
    header_status: true,
    header_bg:
      "https://res.cloudinary.com/ahossain/image/upload/v1697439245/settings/yw3cd2xupqwqpqcbxv9l.jpg",
    title: {
      en: "Mega Offer",
      de: "Mega Angebot",
    },
    coupon_code: ["SUMMER21", "WINTER21", "AUGUST21", "OCTOBER21"],
  },
  privacy_policy: {
    status: true,
    header_bg:
      "https://res.cloudinary.com/ahossain/image/upload/v1697439245/settings/yw3cd2xupqwqpqcbxv9l.jpg",
    title: {
      en: "Privacy Policy",
      de: "Datenschutz-Bestimmungen",
    },
    description: {
      en: "<h1><strong>Last updated: February 15, 2022</strong></h1>\n<p>At KachaBazar, accessible from kachabazar dot com, one of our main priorities is the privacy of our visitors. This Privacy Policy document contains types of information that is collected and recorded by KachaBazar and how we use it. If you have additional questions or require more information about our Privacy Policy, do not hesitate to contact us.we may receive additional information about you such as your name, email address, phone number, the contents of the message and/or attachments you may send us, and any other information you may choose to provide. When you register for an Account, we may ask for your contact information, including items such as name, company name, address, email address, and telephone number.</p>\n<p>This Privacy Policy applies only to our online activities and is valid for visitors to our website with regards to the information that they shared and/or collect in KachaBazar.we may receive additional information about you such as your name, email address, phone number, the contents of the message and/or attachments you may send us, we may ask for your contact information, including items such as name, company name, address, email address, and telephone number. This policy is not applicable to any information collected offline or via channels other than this website. Our Privacy Policy was created with the help of the Free Privacy Policy Generator.</p>\n<h1><strong>Consent</strong></h1>\n<p>By using our website, you hereby consent to our Privacy Policy and agree to its terms.</p>\n<h1><strong>Information we collect</strong></h1>\n<p>The personal information that you are asked to provide, and the reasons why you are asked to provide it, will be made clear to you at the point we ask you to provide your personal information. If you contact us directly, we may receive additional information about you such may choose to provide. When you register for an Account, we may ask for your contact information, including items such as name, company name, address, email address, and telephone number.</p>\n<p>Please note that the Company will not ask you to share any sensitive data or information via email or telephone. If you receive any such request by email or telephone, please do not respond/divulge any sensitive data or information and forward the information relating to the same to</p>\n<h1><strong>How we use your information</strong></h1>\n<p>We use the information we collect in various ways, including to:</p>\n<ol>\n<li>1. Provide, operate, and maintain our website, to provide you with updates and other information.</li>\n<li>2. Improve, personalize, and expand our website,and other information relating to the website.</li>\n<li>3. Understand and analyze how you use our website, to provide you with updates and other information relating to the website.</li>\n<li>4. Develop new products, services, features, and functionality,and other information relating to the website.</li>\n<li>5. Communicate with you, either directly or through one of our partners, including for customer service, to provide you with updates.</li>\n<li>6. Send you emails. To provide you with updates and other information relating to the website, and for marketing and promotional purposes</li>\n<li>7. Find and prevent fraud. To provide you with updates and other information relating to the website, and for marketing and promotional purposes</li>\n</ol>\n<h1><strong>Log Files</strong></h1>\n<p>KachaBazar follows a standard procedure of using log files. These files log visitors when they visit websites. All hosting companies do this and a part of hosting. The information collected by log files include internet protocol (IP) addresses, browser type, Internet Service Provider (ISP), date and time stamp, referring/exit pages, and possibly the number of clicks. These are not linked to any information that is personally identifiable. The purpose of the information is for analyzing trends, administering the site, tracking users' movement on the website, and gathering demographic information.</p>\n<h1><strong>Advertising Partners Privacy Policies</strong></h1>\n<p>You may consult this list to find the Privacy Policy for each of the advertising partners of KachaBazar. Third-party ad servers or ad networks uses technologies like cookies, JavaScript, or Web Beacons that are used in their respective advertisements and links that appear on KachaBazar, which are sent directly to users' browser. They automatically receive your IP address when this occurs. These technologies are used to measure the effectiveness of their advertising campaigns and/or to personalize the advertising content that you see on websites that you visit. Note that KachaBazar has no access to or control over these cookies that are used by third-party advertisers.</p>\n<h1><strong>Third Party Privacy Policies</strong></h1>\n<p>Third-party ad servers or ad networks uses technologies like cookies, JavaScript, or Web Beacons that are used in their respective advertisements and links that appear on KachaBazar, which are sent directly to users' browser. They automatically receive your IP address when this occurs. These technologies are used to measure the effectiveness of their advertising campaigns and/or to personalize the advertising content that you see on websites that you visit. Note that KachaBazar has no access to or control over these cookies that are used by third-party advertisers.</p>\n<p>KachaBazar's Privacy Policy does not apply to other advertisers or websites. Thus, we are advising you to consult the respective Privacy Policies of these third-party ad servers for more detailed information. It may include their practices and instructions about how to opt-out of certain options. You can choose to disable cookies through your individual browser options. To know more detailed information about cookie management with specific web browsers, it can be found at the browsers' respective websites.</p>\n<h1><strong>CCPA Privacy Rights</strong></h1>\n<p>Under the CCPA, among other rights, California consumers have the right to: Request that a business that collects a consumer's personal data disclose the categories and specific pieces of personal data that a business has collected about consumers. Request that a business delete any personal data about the consumer that a business has collected. Request that a business that sells a consumer's personal data, not sell the consumer's personal data. If you make a request, we have one month to respond to you. If you would like to exercise any of these rights, please contact us.</p>\n<h1><strong>Children's Information</strong></h1>\n<p>Another part of our priority is adding protection for children while using the internet. We encourage parents and guardians to observe, participate in, and/or monitor and guide their online activity.Request that a business delete any personal data about the consumer that a business has collected. If you make a request, we have one month to respond to you. If you would like to exercise any of these rights, please contact us.</p>\n<p>KachaBazar does not knowingly collect any Personal Identifiable Information from children under the age of 13. If you think that your child provided this kind of information on our website, we strongly encourage you to contact us immediately and we will do our best efforts to promptly remove such information from our records.</p>\n",
    },
  },
  term_and_condition: {
    status: true,
    header_bg:
      "https://res.cloudinary.com/ahossain/image/upload/v1697439245/settings/yw3cd2xupqwqpqcbxv9l.jpg",
    title: {
      en: "Terms & Conditions",
      de: "Terms & Bedingungen",
    },
    description: {
      en: '<h1><strong>Welcome to KachaBazar!</strong></h1>\n<p>These terms and conditions outline the rules and regulations for the use of KachaBazar\'s Website, located at https://kachabazar.com/. By accessing this website we assume you accept these terms and conditions. Do not continue to use KachaBazar if you do not agree to take all of the terms and conditions stated on this page.</p>\n<p>The following terminology applies to these Terms and Conditions, Privacy Statement and Disclaimer Notice and all Agreements: Client, You and Your refers to you, the person log on this website and compliant to the Company’s terms and conditions. The Company, refers to our CompanyPartParties or Us refers to both the Client and ourselves. All terms refer to the offer, acceptance and consideration of payment necessary to undertake the process of our assistance to the Client in the most appropriate manner for the express purpose of meeting the Client’s needs in respect of provision of the Company’s stated services, in accordance with and subject to, prevailing law of Netherlands. Any use of the above terminology or other words in the singular, plural, capitalization and/or he/she or they, are taken as interchangeable and therefore as referring to same.</p>\n<h1><strong>Cookies</strong></h1>\n<p>We employ the use of cookies. By accessing KachaBazar, you agreed to use cookies in agreement with the KachaBazar\'s Privacy Policy. Most interactive websites use cookies to let us retrieve the user’s details for each visit. Cookies are used by our website to enable the functionality of certain areas to make it easier for people visiting our website. Some of our affiliate/advertising partners may also use cookies.</p>\n<h1><strong>License</strong></h1>\n<p>Unless otherwise stated, KachaBazar and/or its licensors own the intellectual property rights for all material on KachaBazar. All intellectual property rights are reserved. You may access this from KachaBazar for your own personal use subjected to restrictions set in these terms and conditions.This Agreement shall begin on the date hereof. Our Terms and Conditions were created with the help of the Terms And Conditions Generator.<strong>You must not:</strong></p>\n<ul>\n<li>1. Identifiers (e.g. name, mailing address, email address, phone number, credit/debit card number)</li>\n<li>2. Characteristics of protected classifications (e.g. gender, age)</li>\n<li>3. Commercial information (e.g. products or services purchased, purchase history)</li>\n<li>4. Internet or other electronic network activity (e.g. browse or search history)</li>\n<li>5. Geo location data (e.g. latitude or longitude)</li>\n<li>6. Audio, electronic, visual, or similar information (e.g. recording of Guest service calls)</li>\n<li>7. Inferences drawn from any of the above (e.g. preferences or characteristics)</li>\n</ul>\n<p>Parts of this website offer an opportunity for users to post and exchange opinions and information in certain areas of the website. KachaBazar does not filter, edit, publish or review Comments prior to their presence on the website. Comments do not reflect the views and opinions of KachaBazar,its agents and/or affiliates. Comments reflect the views and opinions of the person who post their views and opinions. To the extent permitted by applicable laws, KachaBazar shall not be liable for the Comments or for any liability, damages or expenses caused and/or suffered as a result of any use of and/or posting of and/or appearance of the Comments on this website.</p>\n<h1><strong>Content Liability</strong></h1>\n<p>We shall not be hold responsible for any content that appears on your Website. You agree to protect and defend us against all claims that is rising on your Website. No link(s) should appear on any Website that may be interpreted as libelous, obscene or criminal, or which infringes, otherwise violates, or advocates the infringement or other violation of, any third party rights.Without prior approval and written permission, you may not create frames around our Webpages that alter in any way the visual presentation or appearance of our Website.</p>\n<h1><strong>Your Privacy</strong></h1>\n<p>Please read <a href="https://kachabazar-store.vercel.app/privacy-policy" target="_self">Privacy Policy</a></p>\n<h1><strong>Reservation of Rights</strong></h1>\n<p>We reserve the right to request that you remove all links or any particular link to our Website. You approve to immediately remove all links to our Website upon request. We also reserve the right to amen these terms and conditions and it’s linking policy at any time. By continuously linking to our Website, you agree to be bound to and follow these linking terms and conditions.</p>\n<h1><strong>Disclaimer</strong></h1>\n<p>To the maximum extent permitted by applicable law, we exclude all representations, warranties and conditions relating to our website and the use of this website. Nothing in this disclaimer will:</p>\n<ul>\n<li>1. limit or exclude our or your liability for death or personal injury;</li>\n<li>2. limit or exclude our or your liability for fraud or fraudulent misrepresentation;</li>\n<li>3. limit any of our or your liabilities in any way that is not permitted under applicable law; or</li>\n<li>4. exclude any of our or your liabilities that may not be excluded under applicable law.</li>\n</ul>\n<p>The limitations and prohibitions of liability set in this Section and elsewhere in this disclaimer: (a) are subject to the preceding paragraph; and (b) govern all liabilities arising under the disclaimer, including liabilities arising in contract, in tort and for breach of statutory duty. As long as the website and the information and services on the website are provided free of charge, we will not be liable for any loss or damage of any nature.</p>\n',
    },
  },
  faq: {
    page_status: true,
    leftcol_status: true,
    rightcol_status: true,
    header_bg:
      "https://res.cloudinary.com/ahossain/image/upload/v1697439245/settings/yw3cd2xupqwqpqcbxv9l.jpg",
    left_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697687955/settings/faq_qr1y1h.svg",
    title: {
      en: "FAQs",
      de: "Häufig gestellte Fragen",
    },
    faq_one: {
      en: "How does the KachaBazar work?",
      de: "Wie funktioniert der KachaBazar?",
    },
    description_one: {
      en: "Yes. You can cancel your subscription anytime. Your subscription will continue to be active until the end of your current term (month or year) but it will not auto-renew. Unless you delete your account manually, your account and all data will be deleted 60 days from the day your subscription becomes inactive.",
      de: "Ja. Sie können Ihr Abonnement jederzeit kündigen. Ihr Abonnement bleibt bis zum Ende Ihrer aktuellen Laufzeit (Monat oder Jahr) aktiv, verlängert sich jedoch nicht automatisch. Sofern Sie Ihr Konto nicht manuell löschen, werden Ihr Konto und alle Daten 60 Tage nach Inaktivität Ihres Abonnements gelöscht.",
    },
    faq_two: {
      en: "Can I cancel my subscription anytime?",
      de: "Kann ich mein Abonnement jederzeit kündigen?",
    },
    description_two: {
      en: "Distinctively initiate error-free channels with highly efficient ROI. Intrinsicly envisioneer world-class data via best-of-breed best practices. Efficiently enable empowered e-tailers after cross-unit services. Uniquely expedite seamless e-tailers via cooperative interfaces. Monotonectally myocardinate customer directed meta-services whereas error-free scenarios.",
      de: "Ja. Sie können Ihr Abonnement jederzeit kündigen. Ihr Abonnement bleibt bis zum Ende Ihrer aktuellen Laufzeit (Monat oder Jahr) aktiv, verlängert sich jedoch nicht automatisch. Sofern Sie Ihr Konto nicht manuell löschen, werden Ihr Konto und alle Daten 60 Tage nach Inaktivität Ihres Abonnements gelöscht.",
    },
    faq_three: {
      en: "Whice payment method you should accept?",
      de: "Welche Zahlungsmethode sollten Sie akzeptieren?",
    },
    description_three: {
      en: "Holisticly engage sticky niche markets before collaborative collaboration and idea-sharing. Phosfluorescently facilitate parallel applications with unique imperatives. Proactively plagiarize functionalized deliverables via inexpensive solutions. Collaboratively embrace web-enabled infomediaries rather than diverse testing procedures.",
      de: "Ja. Sie können Ihr Abonnement jederzeit kündigen. Ihr Abonnement bleibt bis zum Ende Ihrer aktuellen Laufzeit (Monat oder Jahr) aktiv, verlängert sich jedoch nicht automatisch. Sofern Sie Ihr Konto nicht manuell löschen, werden Ihr Konto und alle Daten 60 Tage nach Inaktivität Ihres Abonnements gelöscht.",
    },
    faq_four: {
      en: "Can I cancel my subscription anytime?",
      de: "Can I cancel my subscription anytime?",
    },
    description_four: {
      en: "Continually impact seamless imperatives for best-of-breed best practices. Phosfluorescently facilitate parallel applications with unique imperatives. Proactively plagiarize functionalized deliverables via inexpensive solutions. Collaboratively embrace web-enabled infomediaries rather than diverse testing procedures.",
      de: "Continually impact seamless imperatives for best-of-breed\nbest practices. Phosfluorescently facilitate parallel\n                      applications with unique imperatives. Proactively\n                      plagiarize functionalized deliverables via inexpensive\n                      solutions. Collaboratively embrace web-enabled\n                      infomediaries rather than diverse testing procedures.",
    },
    faq_five: {
      en: "What is KachaBazar EC2 auto scaling?",
      de: "Was ist die automatische Skalierung von KachaBazar EC2?",
    },
    description_five: {
      en: "Continually impact seamless imperatives for best-of-breed best practices. Phosfluorescently facilitate parallel applications with unique imperatives. Proactively plagiarize functionalized deliverables via inexpensive solutions. Collaboratively embrace web-enabled infomediaries rather than diverse testing procedures.",
      de: "Kontinuierliche Umsetzung nahtloser Anforderungen für Best-of-Breed-Best Practices. Phosfluoreszierend erleichtert parallele Anwendungen mit einzigartigen Anforderungen. Plagiieren Sie proaktiv funktionalisierte Ergebnisse mit kostengünstigen Lösungen. Nutzen Sie gemeinsam webbasierte Infomediaries anstelle verschiedener Testverfahren.",
    },
    faq_six: {
      en: "What are the benefits of using KachaBazar affliate?",
      de: "Welche Vorteile bietet die Nutzung eines Cloud Clever-Partners?",
    },
    description_six: {
      en: "Continually impact seamless imperatives for best-of-breed best practices. Phosfluorescently facilitate parallel applications with unique imperatives. Proactively plagiarize functionalized deliverables via inexpensive solutions. Collaboratively embrace web-enabled infomediaries rather than diverse testing procedures.",
      de: "Kontinuierliche Umsetzung nahtloser Anforderungen für Best-of-Breed-Best Practices. Phosfluoreszierend erleichtert parallele Anwendungen mit einzigartigen Anforderungen. Plagiieren Sie proaktiv funktionalisierte Ergebnisse mit kostengünstigen Lösungen. Nutzen Sie gemeinsam webbasierte Infomediaries anstelle verschiedener Testverfahren.",
    },
    faq_seven: {
      en: "What is a affliates product configuration?",
      de: "Was ist eine Affiliate-Produktkonfiguration?",
    },
    description_seven: {
      en: "Yes. You can cancel your subscription anytime. Your subscription will continue to be active until the end of your current term (month or year) but it will not auto-renew. Unless you delete your account manually, your account and all data will be deleted 60 days from the day your subscription becomes inactive.",
      de: "Ja. Sie können Ihr Abonnement jederzeit kündigen. Ihr Abonnement bleibt bis zum Ende Ihrer aktuellen Laufzeit (Monat oder Jahr) aktiv, verlängert sich jedoch nicht automatisch. Sofern Sie Ihr Konto nicht manuell löschen, werden Ihr Konto und alle Daten 60 Tage nach dem Tag, an dem Ihr Abonnement inaktiv wird, gelöscht.",
    },
    faq_eight: {
      en: "What is fleet management and how is it different from dynamic scaling?",
      de: "Was ist Flottenmanagement und wie unterscheidet es sich von dynamischer Skalierung?",
    },
    description_eight: {
      en: "Distinctively initiate error-free channels with highly efficient ROI. Intrinsicly envisioneer world-class data via best-of-breed best practices. Efficiently enable empowered e-tailers after cross-unit services. Uniquely expedite seamless e-tailers via cooperative interfaces. Monotonectally myocardinate customer directed meta-services whereas error-free scenarios.",
      de: "Initiieren Sie gezielt fehlerfreie Kanäle mit hocheffizientem ROI. Stellen Sie sich durch branchenführende Best Practices erstklassige Daten vor. Ermöglichen Sie leistungsstarken E-Händlern auf effiziente Weise die Bereitstellung abteilungsübergreifender Dienstleistungen. Beschleunigen Sie nahtlose E-Tailer auf einzigartige Weise über kooperative Schnittstellen. Monotone myokardinierte kundengesteuerte Metadienste während fehlerfreier Szenarien.",
    },
  },
  slider: {
    left_right_arrow: false,
    bottom_dots: true,
    both_slider: false,
    first_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697688491/settings/slider-1_rl8qdc.jpg",
    first_title: {
      en: "The Best Quality Products Guaranteed!",
      de: "Die besten Qualitätsprodukte garantiert!",
    },
    first_description: {
      en: "The Best Quality Products Guaranteed!",
      de: "Die besten Qualitätsprodukte garantiert!",
    },
    first_button: {
      en: "Shop Now",
      de: "Jetzt einkaufen",
    },
    first_link: "/search?category=milk-dairy",
    second_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697688491/settings/slider-2_o6aezc.jpg",
    second_title: {
      en: "Best Different Type of Grocery Store",
      de: "Bestes anderes Lebensmittelgeschäft",
    },
    second_description: {
      en: "Quickly aggregate empowered networks after emerging products...",
      de: "Schnelle Bündelung leistungsstarker Netzwerke nach neuen Produkten ...",
    },
    second_button: {
      en: "Shop Now",
      de: "Jetzt einkaufen",
    },
    second_link: "/search?category=fish-meat",
    third_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697688492/settings/slider-3_iw4nnf.jpg",
    third_title: {
      en: "Quality Freshness Guaranteed!",
      de: "Qualitätsfrische garantiert!",
    },
    third_description: {
      en: "Intrinsicly fashion performance based products rather than accurate benefits...",
      de: "Gestalten Sie Produkte grundsätzlich auf Leistung und nicht auf konkrete Vorteile ...",
    },
    third_button: {
      en: "Shop Now",
      de: "Jetzt einkaufen",
    },
    third_link: "/search?category=fruits-vegetable",
    four_img: "https://i.postimg.cc/rscqZJNz/slider-1.webp",
    four_title: {
      en: "The Best Quality Products Guaranteed!",
      de: "Die besten Qualitätsprodukte garantiert!",
    },
    four_description: {
      en: "Dramatically facilitate effective total linkage for go forward processes...",
      de: "Ermöglichen Sie eine effektive Gesamtverknüpfung für weitere Prozesse erheblich.",
    },
    four_button: {
      en: "Shop Now",
      de: "Jetzt einkaufen",
    },
    four_link: "/search?category=fruits-vegetable",
    five_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697688491/settings/slider-2_o6aezc.jpg",
    five_title: {
      en: "Best Different Type of Grocery Store",
      de: "Bestes anderes Lebensmittelgeschäft",
    },
    five_description: {
      en: "Quickly aggregate empowered networks after emerging products...",
      de: "Schnelle Bündelung leistungsstarker Netzwerke nach neuen Produkten ...",
    },
    five_button: {
      en: "Shop Now",
      de: "Jetzt einkaufen",
    },
    five_link: "/search?category=fish-meat",
  },
  checkout: {
    personal_details: {
      en: "Personal Details",
      de: "Persönliche Daten",
    },
    first_name: {
      en: "First Name",
      de: "Vorname",
    },
    last_name: {
      en: "Last Name",
      de: "Familienname, Nachname",
    },
    email_address: {
      en: "Email Address",
      de: "E-Mail-Adresse",
    },
    checkout_phone: {
      en: "Phone Number",
      de: "Telefonnummer",
    },
    shipping_details: {
      en: "Shipping Details",
      de: "Versanddetails",
    },
    street_address: {
      en: "Street Address",
      de: "Straßenadresse",
    },
    city: {
      en: "City",
      de: "Stadt",
    },
    country: {
      en: "Country",
      de: "Land",
    },
    zip_code: {
      en: "Zip Code",
      de: "PLZ",
    },
    shipping_cost: {
      en: "Shipping Cost",
      de: "Versandkosten",
    },
    shipping_name_one: {
      en: "FedEx",
      de: "FedEx",
    },
    shipping_one_cost: 60,
    shipping_one_desc: {
      en: "Delivery: Today Cost :",
      de: "Lieferung: Heute Kosten :",
    },
    shipping_name_two: {
      en: "UPS",
      de: "UPS",
    },
    shipping_two_desc: {
      en: "Delivery: 7 Days Cost :",
      de: "Lieferung: 7 Tage. Kosten :",
    },
    shipping_two_cost: 20,
    payment_method: {
      en: "Payment Method",
      de: "Bezahlverfahren",
    },
    continue_button: {
      en: "Continue Shipping",
      de: "Weiterversand",
    },
    confirm_button: {
      en: "Confirm Order",
      de: "Bestellung bestätigen",
    },
    order_summary: {
      en: "Order Summary",
      de: "Bestellübersicht",
    },
    apply_button: {
      en: "Apply",
      de: "Anwenden",
    },
    sub_total: {
      en: "Subtotal",
      de: "Zwischensumme",
    },
    discount: {
      en: "Discount",
      de: "Rabatt",
    },
    total_cost: {
      en: "TOTAL COST",
      de: "GESAMTKOSTEN",
    },
  },
  dashboard: {
    invoice_message_first: {
      en: "Thank You",
      de: "Danke",
    },
    invoice_message_last: {
      en: "Your order have been received !",
      de: "Ihre Bestellung ist eingegangen!",
    },
    print_button: {
      en: "Print Invoice",
      de: "Rechnung Drucken",
    },
    download_button: {
      en: "Download Invoice",
      de: "Download Rechnung",
    },
    dashboard_title: {
      en: "Dashboard",
      de: "Armaturenbrett",
    },
    total_order: {
      en: "Total Orders",
      de: "Gesamtbestellungen",
    },
    pending_order: {
      en: "Pending Orders",
      de: "Ausstehende Bestellungen",
    },
    processing_order: {
      en: "Processing Order",
      de: "Bearbeitungsauftrag",
    },
    complete_order: {
      en: "Complete Orders",
      de: "Bestellungen abschließen",
    },
    recent_order: {
      en: "Recent Orders",
      de: "letzte Bestellungen",
    },
    my_order: {
      en: "My Orders",
      de: "Meine Bestellungen",
    },
    update_profile: {
      en: "Update Profile",
      de: "Profil aktualisieren",
    },
    full_name: {
      en: "Full Name",
      de: "Vollständiger Name",
    },
    address: {
      en: "Address",
      de: "Adresse",
    },
    user_phone: {
      en: "Phone/Mobile",
      de: "Mobiltelefon",
    },
    user_email: {
      en: "Email Address",
      de: "E-Mail-Adresse",
    },
    update_button: {
      en: "Update Profile",
      de: "Profil aktualisieren",
    },
    current_password: {
      en: "Current Password",
      de: "Aktuelles Passwort",
    },
    new_password: {
      en: "New Password",
      de: "Neues Kennwort",
    },
    change_password: {
      en: "Change Password",
      de: "Kennwort ändern",
    },
  },
  footer: {
    promo_status: true,
    block1_status: true,
    block2_status: true,
    block3_status: true,
    block4_status: true,
    payment_method_status: true,
    bottom_contact_status: true,
    social_links_status: true,
    shipping_card: {
      en: "Free Shipping From €500.00",
      de: "Kostenloser Versand ab 500,00 €",
    },
    support_card: {
      en: "Support 24/7  At Anytime",
      de: "Support rund um die Uhr und jederzeit",
    },
    payment_card: {
      en: "Secure Payment  Totally Safe",
      de: "Sichere Zahlung, absolut sicher",
    },
    offer_card: {
      en: "Latest Offer Upto 20% Off",
      de: "Aktuelles Angebot: Bis zu 20 % Rabatt",
    },
    block1_title: {
      en: "Company",
      de: "Unternehmen",
    },
    block1_sub_title1: {
      en: "About Us",
      de: "Über uns",
    },
    block1_sub_link1: "/about-us",
    block1_sub_title2: {
      en: "Contact Us",
      de: "Kontaktiere uns",
    },
    block1_sub_link2: "/contact-us",
    block1_sub_title3: {
      en: "Careers",
      de: "Karriere",
    },
    block1_sub_link3: "#",
    block1_sub_title4: {
      en: "Latest News",
      de: "Neueste Nachrichten",
    },
    block1_sub_link4: "#",
    block2_title: {
      en: "Latest News",
      de: "Neueste Nachrichten",
    },
    block2_sub_title1: {
      en: "Fish & Meat",
      de: "Fisch Fleisch",
    },
    block2_sub_link1: "/search?category=fish-meat",
    block2_sub_title2: {
      en: "Soft Drink",
      de: "Erfrischungsgetränk",
    },
    block2_sub_link2: "/search?category=drinks",
    block2_sub_title3: {
      en: "Milk & Dairy",
      de: "Milch und Milchprodukte",
    },
    block2_sub_link3: "/search?category=milk-dairy",
    block2_sub_title4: {
      en: "Beauty & Health",
      de: "Schönheit und Gesundheit",
    },
    block2_sub_link4: "/search?category=beauty-health",
    block3_title: {
      en: "My Account",
      de: "Mein Konto",
    },
    block3_sub_title1: {
      en: "Dashboard",
      de: "Armaturenbrett",
    },
    block3_sub_link1: "/user/dashboard",
    block3_sub_title2: {
      en: "My Orders",
      de: "Meine Bestellungen",
    },
    block3_sub_link2: "/user/my-orders",
    block3_sub_title3: {
      en: "Recent Orders",
      de: "letzte Bestellungen",
    },
    block3_sub_link3: "/user/dashboard",
    block3_sub_title4: {
      en: "Update Profile",
      de: "Profil aktualisieren",
    },
    block3_sub_link4: "/user/update-profile",
    block4_logo:
      "https://res.cloudinary.com/ahossain/image/upload/v1697688576/settings/logo-color_el4zmy.svg",
    block4_address: {
      en: "987 Andre Plain Suite High Street 838, Lake Hestertown, USA",
      de: "987 Andre Plain Suite High Street 838, Lake Hestertown, USA",
    },
    block4_phone: "02.356.1666",
    block4_email: "ccruidk@test.com",
    social_facebook: "https://www.facebook.com/",
    social_twitter: "https://twitter.com/",
    social_pinterest: "https://www.pinterest.com/",
    social_linkedin: "https://www.linkedin.com/",
    social_whatsapp: "https://web.whatsapp.com/",
    payment_method_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1697688607/settings/payment-logo_qhslgz.webp",
    bottom_contact: "+6599887766",
  },
  slug: {
    right_box_status: true,
    card_description_one: {
      en: "Free shipping applies to all orders over shipping €100",
      de: "Kostenloser Versand gilt für alle Bestellungen über 100 € Versandkosten",
    },
    card_description_two: {
      en: "Home Delivery within 1 Hour",
      de: "Lieferung nach Hause innerhalb von 1 Stunde",
    },
    card_description_three: {
      en: "Cash on Delivery Available",
      de: "Lieferung per Nachnahme möglich",
    },
    card_description_four: {
      en: "7 Days returns money back guarantee",
      de: "7 Tage Geld-zurück-Garantie",
    },
    card_description_five: {
      en: "Warranty not available for this item",
      de: "Für diesen Artikel ist keine Garantie verfügbar",
    },
    card_description_six: {
      en: "Guaranteed 100% organic from natural products.",
      de: "Garantiert 100 % biologisch aus Naturprodukten.",
    },
    card_description_seven: {
      en: "Delivery from our pick point Boho One, Bridge Street West, Middlesbrough, North Yorkshire, TS2 1AE.",
      de: "Lieferung von unserem Abholpunkt Boho One, Bridge Street West, Middlesbrough, North Yorkshire, TS2 1AE.",
    },
  },
  seo: {
    favicon:
      "https://res.cloudinary.com/ahossain/image/upload/v1700903173/undefined/favicon.png",
    meta_description: "React Grocery & Organic Food Store e-commerce Template",
    meta_img:
      "https://res.cloudinary.com/ahossain/image/upload/v1636729752/facebook-page_j7alju.png",
    meta_keywords: "e-commerce, online store",
    meta_title:
      "KachaBazar - React Grocery & Organic Food Store e-commerce Template",
    meta_url: "https://kachabazar-store-nine.vercel.app/",
  },
};
